/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;

public class OggContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(OggContainerProbe.class);

    @Override
    public String getName() {
        return "ogg";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream stream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(stream, OggPacketInputStream.OGG_PAGE_HEADER)) {
            return null;
        }
        log.debug("Track {} is an OGG stream.", (Object)reference.identifier);
        AudioTrackInfoBuilder infoBuilder = AudioTrackInfoBuilder.create(reference, stream).setIsStream(true);
        try {
            this.collectStreamInformation(stream, infoBuilder);
        }
        catch (Exception e) {
            log.warn("Failed to collect additional information on OGG stream.", e);
        }
        return MediaContainerDetectionResult.supportedFormat(this, null, infoBuilder.build());
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new OggAudioTrack(trackInfo, inputStream);
    }

    private void collectStreamInformation(SeekableInputStream stream, AudioTrackInfoBuilder infoBuilder) throws IOException {
        OggPacketInputStream packetInputStream = new OggPacketInputStream(stream, false);
        OggMetadata metadata = OggTrackLoader.loadMetadata(packetInputStream);
        if (metadata != null) {
            infoBuilder.apply(metadata);
        }
    }
}

